#ifndef SIMULATOR_H
#define SIMULATOR_H

#include "GlobalDefines.h"
#include "Gate_BASE.h"
#include "Circuit.h"

class Circuit;

class Simulator : public QObject
{
    Q_OBJECT
    public:
        Simulator(Circuit *c, QObject *parent = 0);

    signals:
        void updateStatus(QString status);

    public slots:
        void singleStep(void);
        void autoStep(void);
        void enqueueGate(Gate_BASE *gate);

    private:

        Circuit *circuit;

        QQueue<Gate_BASE*> currQueue;
        QQueue<Gate_BASE*> nextQueue;


};

#endif // SIMULATOR_H
